#ifndef __DM_ETHERNET_H__
#define __DM_ETHERNET_H__

////////////////////////////////////////////////////////////////////////////////

#include "dm_nutypedefs.h"

#ifdef __cplusplus
extern "C" {
#endif

////////////////////////////////////////////////////////////////////////////////

typedef INT32 (*ECONNFUNC)(UINT32 param, UINT32 remoteIp, UINT16 remotePort, UINT32 socket);
typedef INT32 (*ETCPDATAFUNC)(UINT32 param, UINT8 * pData, UINT32 dataBytes);
typedef INT32 (*EUDPDATAFUNC)(UINT32 param, UINT8 * pData, UINT32 dataBytes, UINT32 ipAddr, UINT16 port);
typedef INT32 (*EDISCONNFUNC)(UINT32 param);

////////////////////////////////////////////////////////////////////////////////

extern INT32 NetListenOnTcpPort(UINT16 tcpPort, UINT32 maxConnections,
    ECONNFUNC pfNewConnection, EDISCONNFUNC pfDisConnection, ETCPDATAFUNC pfRxData, UINT32 param);

extern INT32 NetListenOnUdpPort(UINT16 udpPort, EUDPDATAFUNC pfRxData, UINT32 param,
    UINT32 * pSocket);
extern INT32 NetTcpConnect(UINT32 ipAddr, UINT16 tcpPort, ECONNFUNC pfNewConnection,
    ETCPDATAFUNC pfRxData, UINT32 param);
extern struct netif *NetGetInterface(void);
extern INT32 NetCreateUdpSendSocket(void);
extern INT32 NetSendTcpData(UINT32 socket, UINT8* pSrc, UINT32 byteCnt);
extern INT32 NetSendUdpData(UINT32 socket, UINT8* pSrc, UINT32 byteCnt, UINT32 ipAddr, UINT16 port);
extern INT32 NetClose(UINT32 socket, BOOL abort);

extern INT32 NetGetHostByName(char * tempHostname, UINT32 * pIpAddr);
extern UINT32 NetGetIPAddress(void);
extern UINT32 NetGetSubnetMask(void);
extern UINT32 NetGetDefRoute(void);
void RetrieveHWAddr (UINT8 *ether_addr);
extern BOOL NetInitComplete(void);
extern void NetGetHostname(char * myHostname, UINT32 byteCnt);
extern BOOL NetHostnameIsValid(char *);
extern void NetSetHostname(char *);
extern void NetDhcpSetDomainName(const char *pDomainName, UINT16 DomainNameSize);
extern void NetSetDnsIp(UINT8* pDnsServerIp, UINT8 DnsInst);
extern void NetFlushDnsCache(void);
extern UINT8 NetGetDhcpOpt(void);
UINT16 NetGetDHCPLeaseTime(void);
extern UINT32 NetGetDhcpServerAddr(void);
extern BOOL NetArpGetMac(UINT32 IPv4Addr, UINT8* pMacAddrBuf, UINT8 pMacAddrBufSize);
BOOL NetArpQuery(UINT32 IPv4Addr);

extern UINT32 GetIpV4AddrFromString(char* pIpString); // Gets an IPv4 address from string

#define DHCP_OK           0
#define DHCP_DEVICE_FAIL  1
#define DHCP_NO_MEMORY    2
#define DHCP_FAIL         3

UINT8 IsDHCPEnabled(void);
UINT8 SetupDhcp(void);
UINT8 ReleaseDhcp(void);
void EthRestartDhcp(void);
extern BOOL IsIpAddressValid(void);

// define in processor specific file:
extern void EthConsoleTx(UINT8 *data, UINT32 count, UINT32 inst);
extern UINT8 EthGetConsoleLock(UINT32 inst, UINT8 lock);
extern void closeAllEthConsole(UINT8 reboot);

extern void EthInitializeInterface(void);
#ifdef NO_LWIP
extern void EthInitializeInterface_WithoutLWIP(void);
#endif
extern void EthPhyCtrl(BOOL);
extern UINT8 GetPhyLinkStatus(void);
void EthPhyReset(void);
INT32 EthPhyReadBlock(UINT32 inst, UINT32 addr, UINT8 * pDest, UINT32 byteCnt);
INT32 EthPhyWriteBlock(UINT32 inst, UINT32 addr, UINT8 * pSrc, UINT32 byteCnt);
extern BOOL EthLinkStatusOK(void);
extern INT32 EthCheckInitDone(void);

enum
{
    AUTONEG_ON,
    AUTONEG_OFF_10MPS_HALFDUPLEX,
    AUTONEG_OFF_10MPS_FULLDUPLEX,
    AUTONEG_OFF_100MPS_HALFDUPLEX,
    AUTONEG_OFF_100MPS_FULLDUPLEX
};

typedef enum
{
  DISPLAY_CURRENT_ENET_SETTINGS = 0,
  DISPLAY_INITIAL_ENET_SETTINGS,
  DISPLAY_ADVANCED_ENET_SETTINGS,
  DISPLAY_HELP_ENET_SETTINGS,
} ETH_DISPLAY_MODE;
////////////////////////////////////////////////////////////////////////////////
typedef struct
{
	UINT8 PasswordEnabled;
	UINT8 PasswordLength;
	UINT8 PasswordString[14];
}PASSWORD_PARAM;

#define DM_MAC_ADDR_LEN        0x6
#define DM_HOST_NAME_LEN       64
#define ETHSW_MAX_NUMPORTS     6 //support for upto Marvell 6 port switch

typedef struct
{
  UINT32  ip_address;
  UINT32  subnet_mask;
	UINT32  def_router;
	UINT32  pri_DNS;
	UINT8   Enabled;              // used to disable the card from setup
	UINT8   AutoNegotiate;        // can be used later if needed.
	UINT8   ICMPDisable;
	UINT8   UseDHCP;
  UINT8   MacAddr[DM_MAC_ADDR_LEN];
	char    HostName[DM_HOST_NAME_LEN];
	UINT8   ethernet_CIP_mode;
	UINT8   DhcpTimeStamp[4];
    UINT8   spare[13];
	UINT16  CIP_PortNum;         // port number for the CIP connections
	UINT16  CTP_PortNum;         // port number for the CTP console connections
  PASSWORD_PARAM password;        // console password parameters
  UINT8   AutodiscoveryEnabled;
}ETHER_PARAM;

ETHER_PARAM *GetEnetParams(void);
ETHER_PARAM *GetEnetParamsAddrFlash(void);

#define FULL_DOMAIN_NAME_MAX_CHARS 253
#define DOMAIN_NAME_LABEL_MAX_CHARS 63

// 72 is chosen since it's big enough to hold one label + generic top level domain (incl country)
// and it fits the maximum length found in Microsoft naming conventions (OU 64 chars)
// Must match the number used in LWIP options header
#define CRESTRON_DOMAIN_NAME_SIZE 72
#define IPV4_ADDR_LEN 4
#define PRIMARY_DNS   0
#define SECONDARY_DNS 1
#define DHCP_OPTIONS_HOSTNAME 0 // DHCP options have to be the same as the ones used in lwip DHCP
#define DHCP_OPTIONS_FQDN 1
#define MAX_DNS_SERVERS 2 // Must match LWIP defines

typedef struct
{
  UINT32  SecondDns;
  UINT8   DhcpOptions;
  UINT8   NameResolutionMode;
  char    DomainName[CRESTRON_DOMAIN_NAME_SIZE];
}EXTND_ETH_PARAM;

// For reading current ethernet settings without multiple calls and structs
#define ETH_ADAPTER_NAME_SIZE  16
typedef struct
{
  ETHER_PARAM EthParams;
  EXTND_ETH_PARAM ExtEthParams;
  UINT8 LinkState;
  char  EthAdapter[ETH_ADAPTER_NAME_SIZE];
  UINT32 DhcpServerAddr;
  UINT32 LeaseTime;
  UINT32 RenewTime;
  UINT32 RebindTime;
}ETH_SETTINGS;

EXTND_ETH_PARAM *GetExtndEthParams(void);
BOOL GetCurrentEthParams(ETH_SETTINGS* CurrentEthSettings);

// console command routines
INT32 SetIP_Address(UINT32 ignore, char * cmd);
INT32 SetPriDNSIP_Address(UINT32 ignore, char * cmd);
INT32 SetSecDNSIP_Address(UINT32 ignore, char * cmd);
INT32 SetDR_Address(UINT32 ignore, char * cmd);
INT32 SetSM_Address(UINT32 ignore, char * cmd);
INT32 EnterHostName(UINT32 ignore, char * cmd);
INT32 SetMAC_Address(UINT32 ignore, char * cmd);
INT32 SetCTPPort(UINT32 ignore, char * cmd);
INT32 EnableDHCP(UINT32 ignore, char * cmd);
INT32 DhcpRenew(UINT32 ignore, char * cmd);
INT32 DhcpRelease(UINT32 ignore, char * cmd);
INT32 AddMaster(UINT32 ignore, char * cmd);
INT32 ShowEnetStatus(UINT32 ignore, char * cmd);
INT32 RemMaster(UINT32 ignore, char * cmd);
INT32 EthernetUpgrade(UINT32 ignore, char * cmd);
INT32 NonEthernetUpgrade(UINT32 ignore, char * cmd);
INT32 EthStackCmd(UINT32 ignore, char* cmd);
INT32 IpConfigCmd(UINT32 ignore, char* cmd);
extern void MemorizeEthernetJoinStates(void);

INT32 InitEnetParams(void);  // initialize ethernet parameters from NVL at poweron
void EthernetSetDefaults(void);
void DisplayLinkStatus(void);
void DisplayEthernetAddresses(UINT8 Current);
extern void DisplayEthernetSettings(ETH_DISPLAY_MODE Mode);
void DisplayDnsServer(UINT8 ServerInst);
UINT32 CTPGetPort(void);
void CresnetSlaveMemorizeIPConfig(void);
void CresnetSlaveMemorizeIPT(void);
void SetDhcpTimeStamp( void );
UINT32 GetDhcpTimeStamp( void );

UINT8 *IpConfigJoin(UINT8 StreamId);
UINT8 *IpTJoin(UINT8 StreamId);
UINT8 *HIDConfigJoin(UINT8 bConnectionType, UINT8 bDataTypes);

void *GetEthernetDevice(void);

extern BOOL EthIntfcInitialized;
extern BOOL EthIntfcParamFailure;

typedef enum
{
    ERR_ETH_MAC_INIT = 0,             //00  unable to initialize MAC interface in time
    ERR_ETH_CONSOLE_INIT,             //01  console initialization failed
    ERR_ETH_AUTODISC_INIT,            //02  Autodiscovery initialization failed - socket error
    ERR_ETH_TCP_RECV,                 //03  TCP Receive error
    ERR_ETH_UDP_RECV,                 //04  UDP Receive error
    ERR_ETH_LWIP_CREATETASK,          //05  Could not create task
    ERR_ETH_LWIP_FREETASK,            //06  Could not delete task
    ERR_ETH_LWIP_INVALIDTASKSTATE,    //07  Task state is invalid
    ERR_ETH_AUTODISC_MEMALLOCFAILED,  //08  Memory allocation for hostname failed
    ERR_ETH_RSTPERROR,                //09  STP Error
    ERR_ETH_TCPSEM_TIMEDOUT,          //10  TCP semaphore took too long to send a message
    ERR_ETH_MBOX_TIMEDOUT,            //11  TCP mailbox took too long to send a message
    ERR_ETH_CONSOLE_LOCK_FAILED,      //12  Could not get a lock to the console within timeout period
    ERR_ETH_MACADDRESS_INVALID,       //13  MAC Address is invalid
    ERR_ETH_CIPPKT_TOOLARGE,          //14  CIP packet was too large
    ERR_ETH_FPGA_MDC_MDIO_ERR,        //15  FPGA MDC/MDIO Error (6x1)
    ERR_ETH_PHY_ERR,                  //16  PHY acces error
    ERR_ETH_PHY_PCR_ERR,              //17  None CPU PCR bit11 set (for Marvell chip)
    ERR_ETH_COULD_NOT_INIT_DHCP_TASK, //18  could not make DHCP task
    ERR_ETH_MALLOC_ERR,               //19  Malloc failed for TCP helper
    ERR_NET_TCP_MAX_HELPERS_ERR,      //20  tcp helpers maxed out
    ERR_NET_SWITCH_API_INIT_FAIL,     //21  API init fail
    ERR_NET_SWITCH_PIRL_READ_FAIL,    //22  API init fail
    ERR_NET_SWITCH_PORT_VLAN_CONFIG_FAIL,     //23  API init fail
    ERR_NET_SWITCH_8021Q_VLAN_CONFIG_FAIL,    //24  802.1Q VLAN init fail
    ERR_NET_DNS_AUTO_DISC_INIT_FAIL,          //25 DnsAutoDiscover init fail
    ERR_NET_DNS_AUTO_DISC_NAME_RESOLUTION,    //26 DnsAutoDiscover name resolution error
    ERR_NET_DNS_AUTO_DISC_HOSTNAME,           //27 DnsAutoDiscover bad hostname
    ERR_ETH_SWITCH_HARDWARE_RESET_FAILED,     // 28 hardware reset failed
    ERR_ETH_MBOX_FULL,                        // 29
    ERR_ETH_DELETING_NOT_EMPTY_MBOX,          // 30
    ERR_ETH_HTTP_SERVER_INIT                  // 31 HTTP server initialization failed	
}ERRORETHERNET;

enum
{
  ERR_ETH_MALLOC_ERR_CAUSE_TCP_HELPER,
  ERR_ETH_MALLOC_ERR_CAUSE_PIRL_PRINT,
	ERR_ETH_MALLOC_ERR_CAUSE_PIRL_SETUP
};

enum
{
    ERR_ETH_SWITCH_API_INIT_ERR_CAUSE_NULL_CONFIG_MEMBER_POINTERS,
    ERR_ETH_SWITCH_API_INIT_ERR_CAUSE_MANAGED_HARDWARE_INIT_FAILED,
    ERR_ETH_SWITCH_API_INIT_ERR_CAUSE_UMANAGED_HARDWARE_INIT_FAILED

};
enum
{
	ERR_ETH_SWITCH_HARDWARE_RESET_ERR_CAUSE_UMANAGED_HARDWARE_INIT_FAILED,
	ERR_ETH_SWITCH_HARDWARE_RESET_ERR_CAUSE_INIT_INCOMPLETE,
	ERR_ETH_SWITCH_HARDWARE_RESET_ERR_CAUSE_RSTP_DISABLE_FAILED,
	ERR_ETH_SWITCH_HARDWARE_RESET_ERR_CAUSE_SEM_DELETE_FAILED
};

// See http://en.wikipedia.org/wiki/EtherType
enum ETHER_TYPE
{
    ETH_TYPE_IPV4       = 0x0800,
    ETH_TYPE_ARP        = 0x0806,
    ETH_TYPE_VLAN       = 0x8100,
    ETH_TYPE_PPPOE_DISC = 0x8863,
    ETH_TYPE_PPPOE_SESS = 0x8864,
    ETH_TYPE_EAP        = 0x888E,
    ETH_TYPE_LLDP       = 0x88CC,
};

extern ETHER_PARAM InitialEtherParam;
extern ETHER_PARAM *pEtherParam;   // pointer to working copy for changes
extern EXTND_ETH_PARAM *pExtndEthParam;

#define IPADDR_RDY_WAIT_MS       (500)
#ifdef PROAMP_7X400
#define DM_FORCED_GW             (0x00000000) // 0.0.0.0
#define DM_FORCED_SNMASK         (0x00FFFFFF) // 255.255.255.0
#else
#define DM_FORCED_GW             (0x0101A8C0) // 192.168.1.1
#define DM_FORCED_SNMASK         (0x00FFFFFF) // 255.255.255.0
#endif // PROAMP_7X400

// New members for _AppBLoaderSharedData should be added to the top instead of the usual placement to keep
// existing members in the same address between the bootloader and application. This also preserves backward compatibility
typedef struct _AppBLoaderSharedData
{
#ifdef STM32F2XX
    UINT8 warmReboot[4];     // Signature for warm reboot
#endif
    UINT8 reserved[3];       // from old depricated UINT32 TSID
    UINT8 bHDBaseTDMNETState; // from old depricated UINT32 TSID
    ///aws. 7 to keep unpacked struct even
    UINT8  numEgressPorts;
    UINT8  egressRateLimit[7];//7
    ////
    UINT8  isDHCPEnabled;     // Indicates if DHCP was enabled before going to bootloader
    UINT8  isPHYLocal;        // true if using the processor's phy
    UINT8  PHYAddr;           // address of the phy on the mii bus
    UINT8  MACAddr[6];        // MAC Address of Device
    UINT32 currIPAddr;        // If static, saved IP. Otherwise, DHCP offered IP
    UINT32 currSNMask;        // If static, saved SMask. Otherwise, DHCP offered Smask
    UINT32 currDefRouter;     // If static, saved Def Router. Otherwise, DHCP offered Def Router
    UINT16 currCTPPort;       // Constant for DM devices
    UINT8  hostName[DM_HOST_NAME_LEN];     // Current hostname saved in NVL

} AppBLoaderSharedData;

typedef void (*PTERLAPPBLE)( AppBLoaderSharedData* );
extern PTERLAPPBLE g_pSwitchSaveAppBLE;
#define DM_HDBASET_DMNET_DISABLED_STATE 0xAA
#define DM_HDBASET_DMNET_ENABLED_STATE  0

extern void *GetEthernetDeviceHwAddr(void);
extern UINT32 enet_rx_unicast_frames;
extern UINT32 enet_rx_bcast_frames;
extern UINT32 enet_rx_mcast_frames;
extern UINT32 enet_rx_errors;
extern UINT32 enet_rx_interrupt_frames;
extern UINT32 enet_rx_unknown;
extern UINT32 dma_busy_pkt_dropped_count;
extern UINT32 dma_pkt_rcv_count;
extern UINT32 dma_tx_merr_count;
extern UINT32 dma_rx_merr_count;
extern UINT32 dma_pkt_lost_count;
extern UINT32 dma_desc_err_count;

// For ethernet link layer
extern void SetProcLldpFuncPtr(void (*pfFuncPtr)(UINT8* pBuf));

extern void SendEthLinkData(UINT8* pDest, UINT8* pSrc, UINT8* pData, UINT16 Len, UINT16 Type);
extern void PrintEthernetStatistics(char c);
// 2 times bridge_forwdel (30 sec) in msec
#define GRATUITOUS_ARP_SEND_DELAY_TIME   30000
typedef enum {
    GARP_LINK_UP,
    GARP_SEND_CHECK
}GARPSTATE;
extern void ProcessGratuitousArp(GARPSTATE state);

typedef void  (*ETHSWBPDUPROCFUNC)(unsigned char *bpdu, void *device, unsigned long tag, unsigned short len);
typedef int   (*ETHSWDEFMAPFUNC)(void);
typedef void  (*ETHSWRMONFUNC)(void);
typedef INT32  (*ETHSWRESETRMONFUNC)(UINT32 index, char *cmd);

extern ETHSWBPDUPROCFUNC g_pEthSwitch_Marvell_Process_BPDU_fnc;
extern ETHSWDEFMAPFUNC g_pGetCPUDefaultMap_fnc;
extern ETHSWRMONFUNC g_pPrintSwitchRMONCounters_func;
extern ETHSWRESETRMONFUNC g_pethSwResetRMONCountersCmd_func;

#define ethSwitch_Marvell_Header_Support ((g_pEthSwitch_Marvell_Process_BPDU_fnc && g_pGetCPUDefaultMap_fnc && g_pPrintSwitchRMONCounters_func && g_pethSwResetRMONCountersCmd_func))
UINT8  ENET_IsFrameOurs(UINT8 *destAddr);

extern UINT8 mcast_addr[];
extern UINT8 bcast_addr[];

#define ETHSWITCH_MACADDR_LEN             (6)
#define ETHSWITCH_ETHHEADER_LEN           ((2*ETHSWITCH_MACADDR_LEN) + 2)

// Header details for Marvell switches
#define ETHSWITCH_HEADERSIZE              (2)
#define ETHSWITCH_DA_OFFSET               (ETHSWITCH_HEADERSIZE)
#define ETHSWITCH_LLC_ETHFRAME_OFFSET     (ETHSWITCH_HEADERSIZE+ETHSWITCH_ETHHEADER_LEN)

// BPDU LLC related constants
#define ETHSWITCH_LLC_DSAP_STP   0x42
#define ETHSWITCH_LLC_SSAP_STP   0x42
#define ETHSWITCH_LLC_HDR_SIZE   0x3

#define ETHSWITCH_ETHFRAME_ETHTYPE_LEN   0x2
#define ETHSWITCH_ETHFRAME_DA_OFFSET     0x0
#define ETHSWITCH_ETHFRAME_SA_OFFSET     (ETHSWITCH_ETHFRAME_DA_OFFSET+ETHSWITCH_MACADDR_LEN)
#define ETHSWITCH_ETHFRAME_LEN_OFFSET    (ETHSWITCH_ETHFRAME_SA_OFFSET+ETHSWITCH_MACADDR_LEN)

#define ETHSWITCH_LLC_DSAP_OFFSET        (ETHSWITCH_ETHFRAME_LEN_OFFSET+ETHSWITCH_ETHFRAME_ETHTYPE_LEN)
#define ETHSWITCH_LLC_SSAP_OFFSET        (ETHSWITCH_LLC_DSAP_OFFSET+1)
#define ETHSWITCH_LLC_CTL_OFFSET         (ETHSWITCH_LLC_SSAP_OFFSET+1)

// Primitives to construct raw bpdu frame
#define ETHSWITCH_BPDU_HDRSIZE            (ETHSWITCH_ETHHEADER_LEN + ETHSWITCH_LLC_HDR_SIZE)
#define ETHSWITCH_BPDU_DATA_OFFSET       (ETHSWITCH_BPDU_HDRSIZE)
// Class D subnet Mask 255.255.0.0
#define DEFAULT_PRIVATE_NETWORK_SUBNET_MASK            0xFFFF0000
#define DEFAULT_PRIVATE_NETWORK_DEFAULT_ROUTER         0
// Link-local subnet 169.254.0.0
#define PRIVATE_NETWORK_CLASS_D_SCHEME_MASK            0xA9FE0000

#define DEFAULT_PRIVATE_NETWORK_SYSTEM_ID              1
#define MIN_PRIVATE_NETWORK_SYSTEM_ID                  1
#define MAX_PRIVATE_NETWORK_SYSTEM_ID                  64
#define SYSTEM_ID_BITS_MASK                            0x0000FC00

#define MAX_NUMBER_LOCAL_PRIVATE_HOSTS_PER_SYSTEM      (((long)((~DEFAULT_PRIVATE_NETWORK_SUBNET_MASK)+1))/MAX_PRIVATE_NETWORK_SYSTEM_ID) // 1024 Includes master

/* This macro determines if an ethernet address is a link-local (169.254.x.x) ethernet address.
   It works on the most significant two bytes of the ethernet address.  */
#define PNM_INTERNAL_NETWORK_HOST_ADDR(i)        (((long)(NATIVE2BE32(i)) & DEFAULT_PRIVATE_NETWORK_SUBNET_MASK) == PRIVATE_NETWORK_CLASS_D_SCHEME_MASK)


#ifdef __cplusplus
}
#endif

#endif  //__DM_ETHERNET_H__
